/*
 * Decompiled with CFR 0.152.
 */
package EngStats;

import EngStats.TarFileIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.zip.GZIPInputStream;

public class FileIterator {
    private File rootPath;
    private boolean extractTars;
    private boolean extractGzips;
    private Queue<File> files;
    private FileIterator currentIterator;
    private File currentFile;

    public boolean isExtractGzips() {
        return this.extractGzips;
    }

    public boolean isExtractTars() {
        return this.extractTars;
    }

    protected Queue<File> getFiles() {
        return this.files;
    }

    protected FileIterator getCurrentIterator() {
        return this.currentIterator;
    }

    protected File getRootPath() {
        return this.rootPath;
    }

    protected void setCurrentIterator(FileIterator currentIterator) {
        this.currentIterator = currentIterator;
    }

    public FileIterator(String path, boolean extractTars, boolean extractGzips) {
        this.rootPath = new File(path);
        this.extractTars = extractTars;
        this.extractGzips = extractGzips;
        this.files = new LinkedList<File>();
        if (this.rootPath.isDirectory()) {
            File[] fileList = this.rootPath.listFiles();
            if (fileList != null) {
                for (File f : fileList) {
                    this.files.add(f);
                }
            }
        } else {
            this.files.add(this.rootPath);
        }
    }

    protected void next() {
        this.currentFile = this.files.poll();
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public String getCurrentPath() {
        if (this.currentIterator == null) {
            return this.rootPath + "/" + this.getCurrentFile().getName();
        }
        return this.currentIterator.getCurrentPath();
    }

    public InputStream getCurrentStream() {
        try {
            return new FileInputStream(this.currentFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream getNext() {
        InputStream ret;
        if (this.currentIterator == null) {
            this.next();
            File current = this.getCurrentFile();
            if (current == null) {
                return null;
            }
            boolean isGzip = false;
            boolean isTar = false;
            if (current.getName().endsWith("tar.gz") || current.getName().endsWith("tgz")) {
                isGzip = true;
                isTar = true;
            } else if (current.getName().endsWith("gz")) {
                isGzip = true;
            } else if (current.getName().endsWith("tar")) {
                isTar = true;
            }
            if (current.isDirectory()) {
                this.currentIterator = new FileIterator(current.getAbsolutePath(), this.extractTars, this.extractGzips);
            } else if (isTar && this.extractTars && (!isGzip || this.extractGzips)) {
                try {
                    this.currentIterator = new TarFileIterator(current.getAbsolutePath(), this.extractTars, this.extractGzips);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            } else {
                if (isGzip && this.extractGzips) {
                    try {
                        return new GZIPInputStream(this.getCurrentStream());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                return this.getCurrentStream();
            }
        }
        if ((ret = this.currentIterator.getNext()) == null) {
            this.currentIterator.close();
            this.currentIterator = null;
            return this.getNext();
        }
        return ret;
    }

    public void close() {
    }
}

