/*
 * Decompiled with CFR 0.152.
 */
package EngStats;

import EngStats.NumericParser;
import EngStats.URLParser;
import EngStats.ValueComp;
import EngStats.ValueComparator;
import Sanikumar_file_extractor.Dset;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.net.InternetDomainName;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SimpleCounter {
    int fileCounter = 0;
    public double timeStampBefore = 0.0;
    public double timeStampAfter = 0.0;
    public double horizontal = 0.0;
    public double vertical = 0.0;
    public double headers = 0.0;
    public double keyColumns = 0.0;
    public double lastModofied = 0.0;
    public double relationT = 0.0;
    public double othersT = 0.0;
    public double minColHorizontal = 0.0;
    public double minRowHorizontal = 0.0;
    public double maxColHorizontal = 0.0;
    public double maxRowHorizontal = 0.0;
    public double minColVertical = 0.0;
    public double minRowVertical = 0.0;
    public double maxColVertical = 0.0;
    public double maxRowVertical = 0.0;
    public double avgColHori = 0.0;
    public double avgColVerti = 0.0;
    public double avgRowHori = 0.0;
    public double avgRowVerti = 0.0;
    public double all = 0.0;
    public double Header = 0.0;
    int val = 0;
    public Set<String> tldSet = new HashSet<String>();
    public HashMap<String, Integer> notTopPrivateDomainHM = new HashMap();
    public HashMap<String, Integer> topPrivateDomainHM = new HashMap();
    public HashMap<String, Integer> notPublicSuffixHM = new HashMap();
    public HashMap<String, Integer> publicSuffixHM = new HashMap();
    public HashMap<String, Integer> notTopLevelDomainHM = new HashMap();
    public HashMap<String, Integer> topLevelDomainHM = new HashMap();
    public HashMap<String, Integer> headerCount = new HashMap();
    public HashMap<String, Integer> temp = new HashMap();
    public HashMap<Integer, Integer> rowsperHTable = new HashMap();
    public HashMap<Integer, Integer> colsperHTable = new HashMap();
    public HashMap<Integer, Integer> rowsperVTable = new HashMap();
    public HashMap<Integer, Integer> colsperVTable = new HashMap();
    public HashMap<String, Integer> columnDatatype = new HashMap();
    public HashMap<String, Integer> notDomainHM = new HashMap();
    public Map<String, Integer> rowDistriHori = new HashMap<String, Integer>();
    public Map<String, Integer> rowDistriVerti = new HashMap<String, Integer>();
    public Map<String, Integer> colDistriHori = new HashMap<String, Integer>();
    public Map<String, Integer> colDistriVerti = new HashMap<String, Integer>();
    public Map<String, Integer> datatypes = new HashMap<String, Integer>();
    private static final Map<String, String> DATE_FORMAT_REGEXPS = new HashMap<String, String>(){
        {
            this.put("^\\d{1,2}[\\.|\\|/|-]\\d{1,2}[\\.|\\|/|-]\\d{4}$", "dd.MM.yyyy");
            this.put("^\\d{1,2}[\\.|\\|/|-]\\d{1,2}[\\.|\\|/|-]\\d{2}$", "dd.MM.yy");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", "yyyy-MM-dd");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}$", "MM/dd/yyyy");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
            this.put("^\\d{1,2}[/|-|\\.][a-z]{2,}[/|-|\\.]\\d{4}$", "dd/MMMM/yyyy");
            this.put("^\\d{1,2}[/|-|\\.][a-z]{2,}[/|-|\\.]\\d{2}$", "dd/MMMM/yy");
        }
    };

    public void readDir(File dir) throws FileNotFoundException, IOException, URISyntaxException {
        Gson gson = new Gson();
        JsonReader reader = null;
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) {
                String content;
                GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(f.getAbsolutePath()));
                BufferedReader br = new BufferedReader(new InputStreamReader(gzip));
                ++this.fileCounter;
                while ((content = br.readLine()) != null) {
                    reader = new JsonReader(new StringReader(content));
                    reader.setLenient(true);
                    Dset dataset = gson.fromJson(content, Dset.class);
                    if (!dataset.getTableType().equals("ENTITY")) continue;
                    this.otherStats(dataset);
                    String url = dataset.getUrl();
                    this.getTopPrivateDomain(url);
                }
                br.close();
                if (this.fileCounter % 100 != 0) continue;
                System.out.println("File " + this.fileCounter + " finished processing...");
                continue;
            }
            this.readDir(f);
        }
    }

    public void setTLDSet() throws IOException {
        File file = new File("table_of_tlds.html");
        Document doc = Jsoup.parse(file, "UTF-8");
        Elements tables = doc.select("table");
        for (Element table : tables) {
            Elements tRows = table.select("tr:has(td)");
            for (Element tRow : tRows) {
                Elements tCols = tRow.select("td");
                String tld = tCols.get(0).text();
                this.tldSet.add(tld);
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, URISyntaxException {
        String out = args[1];
        if (!new File(out).exists()) {
            new File(out).mkdir();
        }
        File MainDirectory = new File(args[0]);
        SimpleCounter tlDsExtraction = new SimpleCounter();
        tlDsExtraction.setTLDSet();
        tlDsExtraction.readDir(MainDirectory);
        BufferedWriter write = new BufferedWriter(new FileWriter(new File(out + "stats.txt")));
        write.write("Other Statistics:-----------------------------------------------------------\n");
        write.write("Timestamp After Table: " + tlDsExtraction.timeStampAfter + "\n");
        write.write("Timestamp Before Table: " + tlDsExtraction.timeStampBefore + "\n");
        write.write("Horizontal Tables (Only Relation): " + tlDsExtraction.horizontal + "\n");
        write.write("Vertical Tables (Only Relation): " + tlDsExtraction.vertical + "\n");
        write.write("Header Count: " + tlDsExtraction.headers + "\n");
        write.write("Key-Column Count: " + tlDsExtraction.keyColumns + "\n");
        write.write("Last Version Count: " + tlDsExtraction.lastModofied + "\n");
        write.write("Minimum Row Length for Horizontal Tables: " + tlDsExtraction.minRowHorizontal + "\n");
        write.write("Minimum Column Length for Horizontal Tables: " + tlDsExtraction.minColHorizontal + "\n");
        write.write("Maximum Row Length for Horizontal Tables: " + tlDsExtraction.maxRowHorizontal + "\n");
        write.write("Maximum Column Length for Horizontal Tables: " + tlDsExtraction.maxColHorizontal + "\n");
        write.write("Minimum Row Length for Vertical Tables: " + tlDsExtraction.minRowVertical + "\n");
        write.write("Minimum Column Length for Vertical Tables: " + tlDsExtraction.minColVertical + "\n");
        write.write("Maximum Row Length for Vertical Tables: " + tlDsExtraction.maxRowVertical + "\n");
        write.write("Maximum Column Length for Vertical Tables: " + tlDsExtraction.maxColVertical + "\n");
        write.write("AVG Column Length for Horizontal Tables: " + tlDsExtraction.avgColHori / tlDsExtraction.horizontal + "\n");
        write.write("AVG Row Length for Vertical Tables: " + tlDsExtraction.avgRowHori / tlDsExtraction.horizontal + "\n");
        write.write("AVG Column Length for Horizontal Tables: " + tlDsExtraction.avgColVerti / tlDsExtraction.vertical + "\n");
        write.write("AVG Row Length for Vertical Tables: " + tlDsExtraction.avgRowVerti / tlDsExtraction.vertical + "\n");
        write.write("TLDs Statistics:------------------------------------------------------------\n");
        write.write("Detected\n");
        write.write("Top Private Domain: " + tlDsExtraction.topPrivateDomainHM.size() + "\n");
        write.write("Top Level Domain: " + tlDsExtraction.topLevelDomainHM.size() + "\n");
        write.write("Public Siffixes: " + tlDsExtraction.publicSuffixHM.size() + "\n");
        write.write("Not Detected\n");
        write.write("Not Top Private Domain: " + tlDsExtraction.notTopPrivateDomainHM.size() + "\n");
        write.write("Not Top Level Domain: " + tlDsExtraction.notTopLevelDomainHM.size() + "\n");
        write.write("Not Public Siffixes: " + tlDsExtraction.notPublicSuffixHM.size() + "\n");
        write.write("Not Domain: " + tlDsExtraction.notDomainHM.size() + "\n");
        TreeMap<String, Integer> treeMap21 = SimpleCounter.SortByValueString(tlDsExtraction.datatypes);
        TreeMap<String, Integer> treeMap22 = SimpleCounter.SortByValue(tlDsExtraction.headerCount);
        write.flush();
        File file21 = new File(args[1] + "datatypes");
        File file22 = new File(args[1] + "header");
        SimpleCounter.writeMapString(treeMap21, file21);
        SimpleCounter.writeMapString(treeMap22, file22);
        System.out.println("End of operation...");
        write.flush();
        write.close();
        System.out.println("End of operation...");
    }

    public static TreeMap<String, Integer> SortByValue(HashMap<String, Integer> map) {
        ValueComparator vc = new ValueComparator(map);
        TreeMap<String, Integer> sortedMap = new TreeMap<String, Integer>(vc);
        sortedMap.putAll(map);
        return sortedMap;
    }

    public static void writeMapString(Map<String, Integer> map, File file) throws IOException {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            Files.append("Key : " + entry.getKey() + " Value : " + entry.getValue() + " , ", file, Charsets.UTF_8);
        }
    }

    public static void writeMapInt(Map<Integer, Integer> map, File file) throws IOException {
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            Files.append("Key : " + entry.getKey() + " Value : " + entry.getValue() + " , ", file, Charsets.UTF_8);
        }
    }

    public void predictDatatype(String[][] array) {
        for (int i = 0; i < array.length; ++i) {
            int DTlist = 0;
            int DTstring = 0;
            int DTlink = 0;
            int DTnumeric = 0;
            int DTboolean = 0;
            int DTdate = 0;
            String[] col = array[i];
            for (int j = 0; j < col.length; ++j) {
                if (col[j] == null) continue;
                if (col[j].length() < 15 && SimpleCounter.isValidDate(col[j])) {
                    ++DTdate;
                    continue;
                }
                if (col[j].length() < 10 && Boolean.parseBoolean(col[j])) {
                    ++DTboolean;
                    continue;
                }
                if (col[j].length() < 50 && NumericParser.parseNumeric(col[j])) {
                    ++DTnumeric;
                    continue;
                }
                if (URLParser.parseURL(col[j])) {
                    ++DTlink;
                    continue;
                }
                if (col[j].matches("^\\{.+\\|.+\\}$")) {
                    ++DTlist;
                    continue;
                }
                ++DTstring;
            }
            this.temp.put("Boolean", DTboolean);
            this.temp.put("String", DTstring);
            this.temp.put("Numeric", DTnumeric);
            this.temp.put("Link", DTlink);
            this.temp.put("List", DTlist);
            this.temp.put("Date", DTdate);
            TreeMap<String, Integer> treeMap = SimpleCounter.SortByValue(this.temp);
            int val = 0;
            if (this.columnDatatype.containsKey(treeMap.firstKey())) {
                val = this.columnDatatype.get(treeMap.firstKey());
                this.columnDatatype.put(treeMap.firstKey(), val + 1);
                continue;
            }
            this.columnDatatype.put(treeMap.firstKey(), 1);
        }
    }

    public static void writeMap(Map<String, Integer> map, File file) throws IOException {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            Files.append("Key : " + entry.getKey() + " Value : " + entry.getValue() + " , ", file, Charsets.UTF_8);
        }
    }

    public static boolean isValidDate(String dateString) {
        for (String regexp : DATE_FORMAT_REGEXPS.keySet()) {
            if (dateString.toLowerCase().matches(regexp)) {
                return true;
            }
            if (!dateString.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static TreeMap<String, Integer> SortByValueString(Map<String, Integer> map) {
        ValueComp vc = new ValueComp(map);
        TreeMap<String, Integer> sortedMap = new TreeMap<String, Integer>(vc);
        sortedMap.putAll(map);
        return sortedMap;
    }

    public void getTopPrivateDomain(String url) throws URISyntaxException {
        int val = 0;
        String host = new URI(url).getHost();
        if (host.matches("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+")) {
            if (this.notDomainHM.containsKey(url)) {
                val = this.notDomainHM.get(url);
                this.notDomainHM.put(url, val + 1);
            } else {
                this.notDomainHM.put(url, 1);
            }
        } else {
            InternetDomainName internetDomainName = InternetDomainName.from(host);
            if (internetDomainName.isUnderPublicSuffix()) {
                if (this.topPrivateDomainHM.containsKey(internetDomainName.topPrivateDomain().toString())) {
                    val = this.topPrivateDomainHM.get(internetDomainName.topPrivateDomain().toString());
                    this.topPrivateDomainHM.put(internetDomainName.topPrivateDomain().toString(), val + 1);
                } else {
                    this.topPrivateDomainHM.put(internetDomainName.topPrivateDomain().toString(), 1);
                }
            } else if (this.notTopPrivateDomainHM.containsKey(url)) {
                val = this.notTopPrivateDomainHM.get(url);
                this.notTopPrivateDomainHM.put(url, val + 1);
            } else {
                this.notTopPrivateDomainHM.put(url, 1);
            }
            val = 0;
            if (internetDomainName.hasPublicSuffix()) {
                if (this.publicSuffixHM.containsKey(internetDomainName.publicSuffix().toString())) {
                    val = this.publicSuffixHM.get(internetDomainName.publicSuffix().toString());
                    this.publicSuffixHM.put(internetDomainName.publicSuffix().toString(), val + 1);
                } else {
                    this.publicSuffixHM.put(internetDomainName.publicSuffix().toString(), 1);
                }
            } else if (this.notPublicSuffixHM.containsKey(url)) {
                val = this.notPublicSuffixHM.get(url);
                this.notPublicSuffixHM.put(url, val + 1);
            } else {
                this.notPublicSuffixHM.put(url, 1);
            }
            val = 0;
            int l = internetDomainName.toString().split("\\.").length;
            String tld = "." + internetDomainName.toString().split("\\.")[l - 1];
            if (this.tldSet.contains(tld)) {
                if (this.topLevelDomainHM.containsKey(tld)) {
                    val = this.topLevelDomainHM.get(tld);
                    this.topLevelDomainHM.put(tld, val + 1);
                } else {
                    this.topLevelDomainHM.put(tld, 1);
                }
            } else if (this.notTopLevelDomainHM.containsKey(url)) {
                val = this.notTopLevelDomainHM.get(url);
                this.notTopLevelDomainHM.put(url, val + 1);
            } else {
                this.notTopLevelDomainHM.put(url, 1);
            }
        }
    }

    public void otherStats(Dset dataset) {
        String[][] arrayContent = dataset.getRelation();
        if (dataset.getTableOrientation().toLowerCase().equals("horizontal")) {
            int count;
            this.horizontal += 1.0;
            this.predictDatatype(arrayContent);
            if (dataset.getHasHeader().booleanValue()) {
                this.Header += 1.0;
                this.val = 0;
                if (this.rowsperHTable.containsKey(arrayContent[0].length - 1)) {
                    this.val = this.rowsperHTable.get(arrayContent[0].length - 1);
                    this.rowsperHTable.put(arrayContent[0].length - 1, this.val + 1);
                } else {
                    this.rowsperHTable.put(arrayContent[0].length - 1, 1);
                }
                this.val = 0;
                if (this.colsperHTable.containsKey(arrayContent.length)) {
                    this.val = this.colsperHTable.get(arrayContent.length);
                    this.colsperHTable.put(arrayContent.length, this.val + 1);
                } else {
                    this.colsperHTable.put(arrayContent.length, 1);
                }
                for (int i = 0; i < arrayContent.length; ++i) {
                    String[] col = arrayContent[i];
                    this.val = 0;
                    if (this.headerCount.containsKey(col[0].trim())) {
                        this.val = this.headerCount.get(col[0].trim());
                        this.headerCount.put(col[0].trim(), this.val + 1);
                        continue;
                    }
                    this.headerCount.put(col[0].trim(), 1);
                }
            } else {
                this.val = 0;
                if (this.rowsperHTable.containsKey(arrayContent[0].length)) {
                    this.val = this.rowsperHTable.get(arrayContent[0].length);
                    this.rowsperHTable.put(arrayContent[0].length, this.val + 1);
                } else {
                    this.rowsperHTable.put(arrayContent[0].length, 1);
                }
                this.val = 0;
                if (this.colsperHTable.containsKey(arrayContent.length)) {
                    this.val = this.colsperHTable.get(arrayContent.length);
                    this.colsperHTable.put(arrayContent.length, this.val + 1);
                } else {
                    this.colsperHTable.put(arrayContent.length, 1);
                }
            }
            if (dataset.getLastModified() != null) {
                this.lastModofied += 1.0;
            }
            if (dataset.getTableContextTimeStampAfterTable() != null) {
                this.timeStampAfter += 1.0;
            }
            if (dataset.getTableContextTimeStampBeforeTable() != null) {
                this.timeStampBefore += 1.0;
            }
            if (dataset.getHasHeader().booleanValue()) {
                this.headers += 1.0;
            }
            if (dataset.getHasKeyColumn()) {
                this.keyColumns += 1.0;
            }
            this.avgRowHori += (double)arrayContent[1].length;
            this.avgColHori += (double)arrayContent.length;
            if (this.rowDistriHori.containsKey(Integer.toString(arrayContent[1].length))) {
                count = this.rowDistriHori.get(Integer.toString(arrayContent[1].length));
                this.rowDistriHori.put(Integer.toString(arrayContent[1].length), ++count);
            } else {
                this.rowDistriHori.put(Integer.toString(arrayContent[1].length), 1);
            }
            if (this.colDistriHori.containsKey(Integer.toString(arrayContent.length))) {
                count = this.colDistriHori.get(Integer.toString(arrayContent.length));
                this.colDistriHori.put(Integer.toString(arrayContent.length), ++count);
            } else {
                this.colDistriHori.put(Integer.toString(arrayContent.length), 1);
            }
            if (this.minRowHorizontal == 0.0) {
                this.minRowHorizontal = arrayContent[1].length;
            } else if (this.minRowHorizontal > (double)arrayContent[1].length) {
                this.minRowHorizontal = arrayContent[1].length;
            }
            if (this.minColHorizontal == 0.0) {
                this.minColHorizontal = arrayContent.length;
            } else if (this.minColHorizontal > (double)arrayContent.length) {
                this.minColHorizontal = arrayContent.length;
            }
            if (this.maxRowHorizontal == 0.0) {
                this.maxRowHorizontal = arrayContent[1].length;
            } else if (this.maxRowHorizontal < (double)arrayContent[1].length) {
                this.maxRowHorizontal = arrayContent[1].length;
            }
            if (this.maxColHorizontal == 0.0) {
                this.maxColHorizontal = arrayContent.length;
            } else if (this.maxColHorizontal < (double)arrayContent.length) {
                this.maxColHorizontal = arrayContent.length;
            }
        } else {
            this.vertical += 1.0;
            String[][] arrayContent_new = this.transpose(arrayContent);
            this.predictDatatype(arrayContent_new);
            if (dataset.getHasHeader().booleanValue()) {
                this.Header += 1.0;
                this.val = 0;
                if (this.rowsperVTable.containsKey(arrayContent.length - 1)) {
                    this.val = this.rowsperVTable.get(arrayContent.length - 1);
                    this.rowsperVTable.put(arrayContent.length - 1, this.val + 1);
                } else {
                    this.rowsperVTable.put(arrayContent.length - 1, 1);
                }
                this.val = 0;
                if (this.colsperVTable.containsKey(arrayContent[0].length)) {
                    this.val = this.colsperVTable.get(arrayContent[0].length);
                    this.colsperVTable.put(arrayContent[0].length, this.val + 1);
                } else {
                    this.colsperVTable.put(arrayContent[0].length, 1);
                }
                String[] col = arrayContent[0];
                for (int i = 0; i < arrayContent[0].length; ++i) {
                    this.val = 0;
                    if (this.headerCount.containsKey(col[i].trim())) {
                        this.val = this.headerCount.get(col[i].trim());
                        this.headerCount.put(col[i].trim(), this.val + 1);
                        continue;
                    }
                    this.headerCount.put(col[i].trim(), 1);
                }
            } else {
                this.val = 0;
                if (this.rowsperVTable.containsKey(arrayContent.length)) {
                    this.val = this.rowsperVTable.get(arrayContent.length);
                    this.rowsperVTable.put(arrayContent.length, this.val + 1);
                } else {
                    this.rowsperVTable.put(arrayContent.length, 1);
                }
                this.val = 0;
                if (this.colsperVTable.containsKey(arrayContent[0].length)) {
                    this.val = this.colsperVTable.get(arrayContent[0].length);
                    this.colsperVTable.put(arrayContent[0].length, this.val + 1);
                } else {
                    this.colsperVTable.put(arrayContent[0].length, 1);
                }
            }
            if (dataset.getLastModified() != null) {
                this.lastModofied += 1.0;
            }
            if (dataset.getTableContextTimeStampAfterTable() != null) {
                this.timeStampAfter += 1.0;
            }
            if (dataset.getTableContextTimeStampBeforeTable() != null) {
                this.timeStampBefore += 1.0;
            }
            if (dataset.getHasHeader().booleanValue()) {
                this.headers += 1.0;
            }
            if (dataset.getHasKeyColumn()) {
                this.keyColumns += 1.0;
            }
            this.avgRowVerti += (double)arrayContent[1].length;
            this.avgColVerti += (double)arrayContent.length;
            if (this.rowDistriVerti.containsKey(Integer.toString(arrayContent[1].length))) {
                int count = this.rowDistriVerti.get(Integer.toString(arrayContent[1].length));
                this.rowDistriVerti.put(Integer.toString(arrayContent[1].length), ++count);
            } else {
                this.rowDistriVerti.put(Integer.toString(arrayContent[1].length), 1);
            }
            if (this.colDistriVerti.containsKey(Integer.toString(arrayContent.length))) {
                int count = this.colDistriVerti.get(Integer.toString(arrayContent.length));
                this.colDistriVerti.put(Integer.toString(arrayContent.length), ++count);
            } else {
                this.colDistriVerti.put(Integer.toString(arrayContent.length), 1);
            }
            if (this.minRowVertical == 0.0) {
                this.minRowVertical = arrayContent.length;
            } else if (this.minRowVertical > (double)arrayContent.length) {
                this.minRowVertical = arrayContent.length;
            }
            if (this.minColVertical == 0.0) {
                this.minColVertical = arrayContent[1].length;
            } else if (this.minColVertical > (double)arrayContent[1].length) {
                this.minColVertical = arrayContent[1].length;
            }
            if (this.maxRowVertical == 0.0) {
                this.maxRowVertical = arrayContent.length;
            } else if (this.maxRowVertical < (double)arrayContent.length) {
                this.maxRowVertical = arrayContent.length;
            }
            if (this.maxColVertical == 0.0) {
                this.maxColVertical = arrayContent[1].length;
            } else if (this.maxColVertical < (double)arrayContent[1].length) {
                this.maxColVertical = arrayContent[1].length;
            }
        }
    }

    public String[][] transpose(String[][] array) {
        String[][] array_new = new String[array[1].length][array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                array_new[j][i] = array[i][j];
            }
        }
        return array_new;
    }
}

