/*
 * Decompiled with CFR 0.152.
 */
package EngStats;

import EngStats.FileIterator;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;

public class TarFileIterator
extends FileIterator {
    private TarArchiveInputStream archive;
    private TarArchiveEntry currentEntry;
    private InputStream currentStream;

    public TarFileIterator(String path, boolean extractTars, boolean extractGzips) throws FileNotFoundException, IOException {
        super(path, extractTars, extractGzips);
        this.getFiles().clear();
        this.archive = path.endsWith("gz") ? new TarArchiveInputStream(new GzipCompressorInputStream(new BufferedInputStream(new FileInputStream(path)))) : new TarArchiveInputStream(new FileInputStream(path));
    }

    @Override
    protected void next() {
        try {
            this.currentEntry = this.archive.getNextTarEntry();
            this.currentStream = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.currentEntry = null;
            this.currentStream = null;
        }
    }

    @Override
    public File getCurrentFile() {
        if (this.currentEntry == null) {
            return null;
        }
        return new File(this.currentEntry.getName());
    }

    @Override
    public InputStream getCurrentStream() {
        if (this.currentStream == null) {
            byte[] content = new byte[(int)this.currentEntry.getSize()];
            try {
                this.archive.read(content, 0, content.length);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            this.currentStream = new ByteArrayInputStream(content);
        }
        return this.currentStream;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.archive.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 2) {
            System.err.println("Usage: <archive name> <output dir>");
            return;
        }
        TarFileIterator it = new TarFileIterator(args[0], true, true);
        InputStream is = null;
        File fOut = new File(args[1]);
        if (!fOut.exists()) {
            System.out.println("Creating output directory " + fOut.getAbsolutePath());
            fOut.mkdirs();
        }
        while ((is = it.getNext()) != null) {
            File f = new File(fOut, it.getCurrentFile().getName());
            System.out.println("Extracting " + f.getName());
            IOUtils.copy(is, (OutputStream)new FileOutputStream(f));
            is.close();
        }
        it.close();
        System.out.println("done.");
    }
}

