/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BadDelimiterException;
import com.Ostermiller.util.BadLineEndingException;
import com.Ostermiller.util.BadQuoteException;
import com.Ostermiller.util.CSVPrint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class CSVPrinter
implements CSVPrint {
    private static final boolean AUTO_FLUSH_DEFAULT = true;
    protected boolean autoFlush = true;
    private static final boolean ALWAYS_QUOTE_DEFAULT = false;
    protected boolean alwaysQuote = false;
    protected boolean error = false;
    private static final char DELIMITER_DEFAULT = ',';
    protected char delimiterChar = (char)44;
    private static final char QUOTE_DEFAULT = '\"';
    protected char quoteChar = (char)34;
    protected Writer out;
    protected boolean newLine = true;
    private static final char COMMENT_START_DEFAULT = '#';
    protected char commentStart = (char)35;
    private static final String LINE_ENDING_DEFAULT = "\n";
    private static final String LINE_ENDING_SYSTEM = null;
    protected String lineEnding = "\n";

    public void changeDelimiter(char newDelimiter) throws BadDelimiterException {
        if (this.delimiterChar == newDelimiter) {
            return;
        }
        if (newDelimiter == '\n' || newDelimiter == '\r' || newDelimiter == this.delimiterChar || newDelimiter == this.quoteChar) {
            throw new BadDelimiterException();
        }
        this.delimiterChar = newDelimiter;
    }

    public void changeQuote(char newQuote) throws BadQuoteException {
        if (this.quoteChar == newQuote) {
            return;
        }
        if (newQuote == '\n' || newQuote == '\r' || newQuote == this.delimiterChar || newQuote == this.quoteChar) {
            throw new BadQuoteException();
        }
        this.quoteChar = newQuote;
    }

    public void setLineEnding(String lineEnding) throws BadLineEndingException {
        boolean setDefault;
        boolean bl = setDefault = lineEnding == null;
        if (setDefault) {
            lineEnding = System.getProperty("line.separator");
        }
        if (!(LINE_ENDING_DEFAULT.equals(lineEnding) || "\r".equals(lineEnding) || "\r\n".equals(lineEnding))) {
            if (setDefault) {
                lineEnding = LINE_ENDING_DEFAULT;
            } else {
                throw new BadLineEndingException();
            }
        }
        this.lineEnding = lineEnding;
    }

    public CSVPrinter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public CSVPrinter(Writer out) {
        this(out, '#');
    }

    public CSVPrinter(OutputStream out, char commentStart) {
        this(new OutputStreamWriter(out), commentStart);
    }

    public CSVPrinter(Writer out, char commentStart) {
        this(out, commentStart, '\"', ',');
    }

    public CSVPrinter(Writer out, boolean alwaysQuote, boolean autoFlush) {
        this(out, '#', '\"', ',', alwaysQuote, autoFlush);
    }

    public CSVPrinter(Writer out, char commentStart, char quote, char delimiter) throws BadDelimiterException, BadQuoteException {
        this(out, commentStart, quote, delimiter, LINE_ENDING_SYSTEM);
    }

    public CSVPrinter(Writer out, char commentStart, char quote, char delimiter, String lineEnding) throws BadDelimiterException, BadQuoteException, BadLineEndingException {
        this(out, commentStart, quote, delimiter, lineEnding, false, true);
    }

    public CSVPrinter(Writer out, char commentStart, char quote, char delimiter, boolean alwaysQuote, boolean autoFlush) throws BadDelimiterException, BadQuoteException {
        this(out, commentStart, quote, delimiter, LINE_ENDING_SYSTEM, alwaysQuote, autoFlush);
    }

    public CSVPrinter(Writer out, char commentStart, char quote, char delimiter, String lineEnding, boolean alwaysQuote, boolean autoFlush) throws BadDelimiterException, BadQuoteException, BadLineEndingException {
        this.out = out;
        this.commentStart = commentStart;
        this.changeQuote(quote);
        this.changeDelimiter(delimiter);
        this.setLineEnding(lineEnding);
        this.setAlwaysQuote(alwaysQuote);
        this.setAutoFlush(autoFlush);
    }

    public void println(String value) {
        try {
            this.writeln(value);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writeln(String value) throws IOException {
        try {
            this.write(value);
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void println() {
        try {
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writeln() throws IOException {
        try {
            this.out.write(this.lineEnding);
            if (this.autoFlush) {
                this.flush();
            }
            this.newLine = true;
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void println(String[] values) {
        try {
            this.writeln(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writeln(String[] values) throws IOException {
        try {
            this.print(values);
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void print(String[] values) {
        try {
            this.write(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void write(String[] values) throws IOException {
        try {
            for (int i = 0; i < values.length; ++i) {
                this.write(values[i]);
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void println(String[][] values) {
        try {
            this.writeln(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writeln(String[][] values) throws IOException {
        try {
            for (int i = 0; i < values.length; ++i) {
                this.writeln(values[i]);
            }
            if (values.length == 0) {
                this.writeln();
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void printlnComment(String comment) {
        try {
            this.writelnComment(comment);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void writelnComment(String comment) throws IOException {
        try {
            if (comment == null) {
                comment = "";
            }
            if (!this.newLine) {
                this.writeln();
            }
            this.out.write(this.commentStart);
            this.out.write(32);
            block6: for (int i = 0; i < comment.length(); ++i) {
                char c = comment.charAt(i);
                switch (c) {
                    case '\r': {
                        if (i + 1 < comment.length() && comment.charAt(i + 1) == '\n') {
                            ++i;
                        }
                    }
                    case '\n': {
                        this.writeln();
                        this.out.write(this.commentStart);
                        this.out.write(32);
                        continue block6;
                    }
                    default: {
                        this.out.write(c);
                    }
                }
            }
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    public void print(String value) {
        try {
            this.write(value);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    public void write(String value) throws IOException {
        try {
            if (value == null) {
                value = "";
            }
            boolean quote = false;
            if (this.alwaysQuote) {
                quote = true;
            } else if (value.length() > 0) {
                char c = value.charAt(0);
                if (this.newLine && (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z')) {
                    quote = true;
                }
                if (c == ' ' || c == '\f' || c == '\t') {
                    quote = true;
                }
                for (int i = 0; i < value.length(); ++i) {
                    c = value.charAt(i);
                    if (c != this.quoteChar && c != this.delimiterChar && c != '\n' && c != '\r') continue;
                    quote = true;
                }
                if (c == ' ' || c == '\f' || c == '\t') {
                    quote = true;
                }
            } else if (this.newLine) {
                quote = true;
            }
            if (this.newLine) {
                this.newLine = false;
            } else {
                this.out.write(this.delimiterChar);
            }
            if (quote) {
                this.out.write(this.escapeAndQuote(value));
            } else {
                this.out.write(value);
            }
            if (this.autoFlush) {
                this.flush();
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    private String escapeAndQuote(String value) {
        int count = 2;
        block8: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': 
                case '\\': {
                    ++count;
                    continue block8;
                }
                default: {
                    if (c != this.quoteChar) continue block8;
                    ++count;
                }
            }
        }
        StringBuffer sb = new StringBuffer(value.length() + count);
        sb.append(this.quoteChar);
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c == this.quoteChar) {
                        sb.append("\\" + this.quoteChar);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append(this.quoteChar);
        return sb.toString();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public boolean checkError() {
        try {
            if (this.error) {
                return true;
            }
            this.flush();
            if (this.error) {
                return true;
            }
            if (this.out instanceof PrintWriter) {
                this.error = ((PrintWriter)this.out).checkError();
            }
        }
        catch (IOException iox) {
            this.error = true;
        }
        return this.error;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void setAlwaysQuote(boolean alwaysQuote) {
        this.alwaysQuote = alwaysQuote;
    }
}

