/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BinaryDataException;
import com.Ostermiller.util.CmdLn;
import com.Ostermiller.util.CmdLnOption;
import com.Ostermiller.util.CmdLnResult;
import com.Ostermiller.util.FileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Tabs {
    public static final String version = "1.1";
    protected static ResourceBundle labels = ResourceBundle.getBundle("com.Ostermiller.util.Tabs", Locale.getDefault());
    public static final int TABS = -1;
    private static final int DEFAULT_INPUT_TAB_WIDTH = 4;
    private static final int DEFAULT_INPUT_FILE_TAB_WIDTH = -1;
    private static final int DEFAULT_OUTPUT_TAB_WIDTH = 4;
    private static final boolean DEFAULT_MODIFY_BINARY = false;
    private static final int BUFFER_SIZE = 1024;
    private static final int STATE_INIT = 0;
    private static final int STATE_SOMETHING = 1;
    private static final int MAX_SPACES = 128;
    private static final int MAX_TABS = 16;
    private static final int MAX_COMBINED = 256;

    public static void main(String[] args) {
        CmdLn commandLine = new CmdLn(args).setDescription(labels.getString("tabs") + labels.getString("purpose.message"));
        for (TabsCmdLnOption option : TabsCmdLnOption.values()) {
            commandLine.addOption(option.getCmdLineOption());
        }
        int inputTabWidth = -1;
        int outputTabWidth = 4;
        boolean force = false;
        boolean printMessages = false;
        boolean printExtraMessages = false;
        boolean printErrors = true;
        for (CmdLnResult result : commandLine.getResults()) {
            switch ((TabsCmdLnOption)((Object)result.getOption().getUserObject())) {
                case HELP: {
                    commandLine.printHelp();
                    System.exit(0);
                    break;
                }
                case VERSION: {
                    System.out.println(MessageFormat.format(labels.getString("version"), version));
                    System.exit(0);
                    break;
                }
                case ABOUT: {
                    System.out.println(labels.getString("tabs") + " -- " + labels.getString("purpose.message") + "\n" + MessageFormat.format(labels.getString("copyright"), "2002-2007", "Stephen Ostermiller (http://ostermiller.org/contact.pl?regarding=Java+Utilities)") + "\n\n" + labels.getString("license"));
                    System.exit(0);
                    break;
                }
                case WIDTH: {
                    try {
                        inputTabWidth = Integer.parseInt(commandLine.getResult('w').getArgument());
                    }
                    catch (NumberFormatException x) {
                        inputTabWidth = -1;
                    }
                    if (inputTabWidth >= 1 && inputTabWidth <= 20) break;
                    System.err.println(labels.getString("widtherror"));
                    System.exit(1);
                    break;
                }
                case GUESS: {
                    inputTabWidth = -1;
                    break;
                }
                case SPACES: {
                    try {
                        outputTabWidth = Integer.parseInt(commandLine.getResult('s').getArgument());
                    }
                    catch (NumberFormatException x) {
                        outputTabWidth = -1;
                    }
                    if (outputTabWidth >= 1 && outputTabWidth <= 20) break;
                    System.err.println("widtherror");
                    System.exit(1);
                    break;
                }
                case TABS: {
                    outputTabWidth = -1;
                    break;
                }
                case FORCE: {
                    force = true;
                    break;
                }
                case NOFORCE: {
                    force = false;
                    break;
                }
                case REALLYVERBOSE: {
                    printExtraMessages = true;
                    printMessages = true;
                    printErrors = true;
                    break;
                }
                case VERBOSE: {
                    printExtraMessages = false;
                    printMessages = true;
                    printErrors = true;
                    break;
                }
                case QUIET: {
                    printExtraMessages = false;
                    printMessages = false;
                    printErrors = true;
                    break;
                }
                case REALLYQUIET: {
                    printExtraMessages = false;
                    printMessages = false;
                    printErrors = false;
                }
            }
        }
        int exitCond = 0;
        boolean done = false;
        for (String argument : commandLine.getNonOptionArguments()) {
            done = true;
            File source = new File(argument);
            if (!source.exists()) {
                if (printErrors) {
                    System.err.println(MessageFormat.format(labels.getString("doesnotexist"), argument));
                }
                exitCond = 1;
                continue;
            }
            if (!source.canRead()) {
                if (printErrors) {
                    System.err.println(MessageFormat.format(labels.getString("cantread"), argument));
                }
                exitCond = 1;
                continue;
            }
            if (!source.canWrite()) {
                if (printErrors) {
                    System.err.println(MessageFormat.format(labels.getString("cantwrite"), argument));
                }
                exitCond = 1;
                continue;
            }
            try {
                if (Tabs.convert(source, inputTabWidth, outputTabWidth, !force)) {
                    if (!printMessages) continue;
                    System.out.println(MessageFormat.format(labels.getString("modified"), argument));
                    continue;
                }
                if (!printExtraMessages) continue;
                System.out.println(MessageFormat.format(labels.getString("alreadycorrect"), argument));
            }
            catch (IOException x) {
                if (printErrors) {
                    System.err.println(argument + ": " + x.getMessage());
                }
                exitCond = 1;
            }
        }
        if (!done) {
            if (inputTabWidth == -1) {
                System.err.println(labels.getString("stdinguess"));
                exitCond = 1;
            } else {
                try {
                    Tabs.convert(System.in, System.out, inputTabWidth, outputTabWidth, !force);
                }
                catch (IOException x) {
                    System.err.println(x.getMessage());
                    exitCond = 1;
                }
            }
        }
        System.exit(exitCond);
    }

    public static boolean convert(InputStream in, OutputStream out) throws IOException {
        return Tabs.convert(in, out, 4, 4, false);
    }

    public static boolean convert(InputStream in, OutputStream out, int inputTabWidth) throws IOException {
        return Tabs.convert(in, out, inputTabWidth, 4, false);
    }

    public static boolean convert(InputStream in, OutputStream out, int inputTabWidth, int outputTabWidth) throws IOException {
        return Tabs.convert(in, out, inputTabWidth, outputTabWidth, false);
    }

    public static boolean convert(InputStream in, OutputStream out, int inputTabWidth, int outputTabWidth, boolean binaryException) throws IOException {
        int read;
        if ((inputTabWidth < 1 || inputTabWidth > 20) && inputTabWidth != -1) {
            throw new IllegalArgumentException(labels.getString("widtherror"));
        }
        if ((outputTabWidth < 1 || outputTabWidth > 20) && outputTabWidth != -1) {
            throw new IllegalArgumentException(labels.getString("widtherror"));
        }
        boolean state = false;
        int spaces = 0;
        int tabs = 0;
        int tabStops = 0;
        int extraSpaces = 0;
        boolean modified = false;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            block6: for (int i = 0; i < read; ++i) {
                byte b = buffer[i];
                if (binaryException && b != 13 && b != 10 && b != 9 && b != 12 && (b & 0xFF) < 32) {
                    throw new BinaryDataException(labels.getString("binaryexcepion"));
                }
                switch (b) {
                    case 32: {
                        if (!state) {
                            ++spaces;
                            if (++extraSpaces != inputTabWidth) continue block6;
                            ++tabStops;
                            extraSpaces = 0;
                            continue block6;
                        }
                        out.write(b);
                        continue block6;
                    }
                    case 9: {
                        if (!state) {
                            if (spaces > 0) {
                                modified = true;
                            }
                            ++tabs;
                            ++tabStops;
                            extraSpaces = 0;
                            continue block6;
                        }
                        out.write(b);
                        continue block6;
                    }
                    case 10: 
                    case 13: {
                        out.write(b);
                        spaces = 0;
                        tabs = 0;
                        tabStops = 0;
                        extraSpaces = 0;
                        state = false;
                        continue block6;
                    }
                    default: {
                        if (!state) {
                            int j;
                            if (outputTabWidth == -1) {
                                for (j = 0; j < tabStops; ++j) {
                                    out.write(9);
                                }
                            } else {
                                extraSpaces += tabStops * outputTabWidth;
                                tabStops = 0;
                            }
                            for (j = 0; j < extraSpaces; ++j) {
                                out.write(32);
                            }
                            if (extraSpaces != spaces || tabStops != tabs) {
                                modified = true;
                            }
                        }
                        out.write(b);
                        state = true;
                    }
                }
            }
        }
        return modified;
    }

    public static boolean convert(File f) throws IOException {
        return Tabs.convert(f, -1, 4, false);
    }

    public static boolean convert(File f, int inputTabWidth) throws IOException {
        return Tabs.convert(f, inputTabWidth, 4, false);
    }

    public static boolean convert(File f, int inputTabWidth, int outputTabWidth) throws IOException {
        return Tabs.convert(f, inputTabWidth, outputTabWidth, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convert(File f, int inputTabWidth, int outputTabWidth, boolean binaryException) throws IOException {
        File temp = null;
        InputStream in = null;
        OutputStream out = null;
        boolean modified = false;
        try {
            if (inputTabWidth == -1) {
                inputTabWidth = Tabs.guessTabWidth(new FileInputStream(f));
            }
            in = new FileInputStream(f);
            temp = File.createTempFile("LineEnds", null, null);
            out = new FileOutputStream(temp);
            modified = Tabs.convert(in, out, inputTabWidth, outputTabWidth, binaryException);
            in.close();
            in = null;
            out.flush();
            out.close();
            out = null;
            if (modified) {
                FileHelper.move(temp, f, true);
            } else if (!temp.delete()) {
                throw new IOException(MessageFormat.format(labels.getString("tempdeleteerror"), temp.toString()));
            }
        }
        finally {
            if (in != null) {
                in.close();
                in = null;
            }
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
        return modified;
    }

    public static int guessTabWidth(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        int[][] data = new int[128][16];
        int[] spaceData = new int[2048];
        boolean state = false;
        int tabs = 0;
        int spaces = 0;
        int mostTabs = 0;
        int mostSpaces = 0;
        while ((read = in.read(buffer)) != -1) {
            block6: for (int i = 0; i < read; ++i) {
                byte b = buffer[i];
                switch (b) {
                    case 32: {
                        if (state) continue block6;
                        ++spaces;
                        continue block6;
                    }
                    case 9: {
                        if (state) continue block6;
                        ++tabs;
                        continue block6;
                    }
                    case 10: 
                    case 13: {
                        state = false;
                        if (spaces >= 128 || tabs >= 16) continue block6;
                        int[] nArray = data[spaces];
                        int n = tabs;
                        nArray[n] = nArray[n] + 1;
                        if (tabs > mostTabs) {
                            mostTabs = tabs;
                        }
                        if (spaces > mostSpaces) {
                            mostSpaces = spaces;
                        }
                        spaces = 0;
                        tabs = 0;
                        continue block6;
                    }
                    default: {
                        state = true;
                    }
                }
            }
        }
        for (int tabWidth = 2; tabWidth <= 20; ++tabWidth) {
            int mostCombined = 0;
            for (int tabInd = 0; tabInd <= mostTabs; ++tabInd) {
                for (int spaceInd = 0; spaceInd <= mostSpaces; ++spaceInd) {
                    int numLines;
                    int totInd = spaceInd + tabInd * tabWidth;
                    if (totInd >= 256 || (numLines = data[spaceInd][tabInd]) <= 0) continue;
                    if (mostCombined < totInd) {
                        mostCombined = totInd;
                    }
                    int n = totInd;
                    spaceData[n] = spaceData[n] + numLines;
                }
            }
            boolean found = true;
            for (int combInd = 0; found && combInd < mostCombined; combInd += tabWidth) {
                found = spaceData[combInd] > 0;
            }
            if (!found) continue;
            return tabWidth;
        }
        return 2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TabsCmdLnOption {
        HELP(new CmdLnOption(labels.getString("help.option")).setDescription(labels.getString("help.message"))),
        VERSION(new CmdLnOption(labels.getString("version.option")).setDescription(labels.getString("version.message"))),
        ABOUT(new CmdLnOption(labels.getString("about.option")).setDescription(labels.getString("about.message"))),
        WIDTH(new CmdLnOption(labels.getString("width.option"), Character.valueOf('w')).setDescription(labels.getString("w.message")).setRequiredArgument()),
        GUESS(new CmdLnOption(labels.getString("guess.option"), Character.valueOf('g')).setDescription(labels.getString("g.message") + " (" + labels.getString("default") + ")")),
        TABS(new CmdLnOption(labels.getString("tabs.option"), Character.valueOf('t')).setDescription(labels.getString("t.message"))),
        SPACES(new CmdLnOption(labels.getString("spaces.option"), Character.valueOf('s')).setDescription(labels.getString("s.message") + " (" + labels.getString("default") + "=4)").setRequiredArgument()),
        FORCE(new CmdLnOption(labels.getString("force.option"), Character.valueOf('f')).setDescription(labels.getString("f.message"))),
        NOFORCE(new CmdLnOption(labels.getString("noforce.option")).setDescription(labels.getString("noforce.message") + " (" + labels.getString("default") + ")")),
        REALLYVERBOSE(new CmdLnOption(labels.getString("reallyverbose.option"), Character.valueOf('V')).setDescription(labels.getString("V.message"))),
        VERBOSE(new CmdLnOption(labels.getString("verbose.option"), Character.valueOf('v')).setDescription(labels.getString("v.message"))),
        QUIET(new CmdLnOption(labels.getString("quiet.option"), Character.valueOf('q')).setDescription(labels.getString("q.message") + " (" + labels.getString("default") + ")")),
        REALLYQUIET(new CmdLnOption(labels.getString("reallyquiet.option"), Character.valueOf('Q')).setDescription(labels.getString("Q.message")));

        private CmdLnOption option;

        private TabsCmdLnOption(CmdLnOption option) {
            option.setUserObject((Object)this);
            this.option = option;
        }

        private CmdLnOption getCmdLineOption() {
            return this.option;
        }
    }
}

