/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.YearExtensionPolicy;
import java.util.Calendar;

public class YearExtensionAround
implements YearExtensionPolicy {
    private static final int NEAREST_ALLOWED_YEARS_IN_PAST = 50;
    public static final YearExtensionAround NEAREST = new YearExtensionAround(50);
    private static final int LATEST_ALLOWED_YEARS_IN_PAST = 99;
    public static final YearExtensionAround LATEST = new YearExtensionAround(99);
    private static final int CENTURY_ALLOWED_YEARS_IN_PAST = 0;
    private static final int CENTURY_1900_START = 1900;
    public static final YearExtensionAround CENTURY_1900 = new YearExtensionAround(0, 1900);
    private static final int CENTURY_2000_START = 2000;
    public static final YearExtensionAround CENTURY_2000 = new YearExtensionAround(0, 2000);
    private int currentYear;
    private int baseYear;
    private int allowedYearsInPast;

    public static final YearExtensionAround getNearest(int currentYear) {
        return new YearExtensionAround(50, currentYear);
    }

    public static final YearExtensionAround getLatest(int currentYear) {
        return new YearExtensionAround(99, currentYear);
    }

    public YearExtensionAround(int allowedYearsInPast) {
        this(allowedYearsInPast, Calendar.getInstance().get(1));
    }

    public YearExtensionAround(int allowedYearsInPast, int currentYear) {
        this.setAllowedYearsInPast(allowedYearsInPast);
        this.setCurrentYear(currentYear);
    }

    public void setAllowedYearsInPast(int allowedYearsInPast) {
        if (allowedYearsInPast < 0 || allowedYearsInPast >= 100) {
            throw new IllegalArgumentException("Allowed years in past must be in 0 to 99 range");
        }
        this.allowedYearsInPast = allowedYearsInPast;
    }

    public void setCurrentYear(int currentYear) {
        this.currentYear = currentYear;
        this.calculateBaseYear();
    }

    private void calculateBaseYear() {
        this.baseYear = this.currentYear / 100 * 100 - 100;
    }

    public int extendYear(int twoDigitYear) {
        int year = twoDigitYear + this.baseYear;
        if (this.currentYear - year > this.allowedYearsInPast) {
            year += 100;
        }
        return year;
    }
}

