/*
 * Decompiled with CFR 0.152.
 */
package temp_stats;

import java.util.Calendar;

public final class CalendarUtil {
    private CalendarUtil() {
    }

    public static boolean isValidDate(int year, int month, int day) {
        return CalendarUtil.isValidDate(year, month, day, 0, 0, 0);
    }

    public static boolean isValidTime(int hour, int minute, int second) {
        return CalendarUtil.isValidDate(1, 1, 1, hour, minute, second);
    }

    public static boolean isValidDate(int year, int month, int day, int hour, int minute, int second) {
        try {
            CalendarUtil.getValidCalendar(year, month, day, hour, minute, second);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Calendar getValidCalendar(int year, int month, int day) {
        return CalendarUtil.getValidCalendar(year, month, day, 0, 0, 0);
    }

    public static Calendar getValidCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        calendar.set(year, month - 1, day, hour, minute, second);
        calendar.getTimeInMillis();
        return calendar;
    }

    public static void addYears(Calendar calendar, int years) {
        calendar.add(1, years);
    }

    public static void addMonths(Calendar calendar, int months) {
        calendar.add(2, months);
    }

    public static void addDays(Calendar calendar, int days) {
        calendar.add(5, days);
    }

    public static void addHours(Calendar calendar, int hours) {
        calendar.add(10, hours);
    }

    public static void addMinutes(Calendar calendar, int minutes) {
        calendar.add(12, minutes);
    }

    public static void addSeconds(Calendar calendar, int seconds) {
        calendar.add(13, seconds);
    }

    public static void addMillis(Calendar calendar, int millis) {
        calendar.add(14, millis);
    }

    public static boolean sameYear(Calendar one, Calendar two) {
        return one.get(1) == two.get(1);
    }

    public static boolean sameMonth(Calendar one, Calendar two) {
        return one.get(2) == two.get(2) && CalendarUtil.sameYear(one, two);
    }

    public static boolean sameDay(Calendar one, Calendar two) {
        return one.get(5) == two.get(5) && CalendarUtil.sameMonth(one, two);
    }

    public static boolean sameHour(Calendar one, Calendar two) {
        return one.get(11) == two.get(11) && CalendarUtil.sameDay(one, two);
    }

    public static boolean sameMinute(Calendar one, Calendar two) {
        return one.get(12) == two.get(12) && CalendarUtil.sameHour(one, two);
    }

    public static boolean sameSecond(Calendar one, Calendar two) {
        return one.get(13) == two.get(13) && CalendarUtil.sameMinute(one, two);
    }

    public static boolean sameTime(Calendar one, Calendar two) {
        return one.getTimeInMillis() == two.getTimeInMillis();
    }

    public static int elapsedYears(Calendar before, Calendar after) {
        return CalendarUtil.elapsed(before, after, 1);
    }

    public static int elapsedMonths(Calendar before, Calendar after) {
        return CalendarUtil.elapsed(before, after, 2);
    }

    public static int elapsedDays(Calendar before, Calendar after) {
        return CalendarUtil.elapsed(before, after, 5);
    }

    public static int elapsedHours(Calendar before, Calendar after) {
        return (int)CalendarUtil.elapsedMillis(before, after, 3600000);
    }

    public static int elapsedMinutes(Calendar before, Calendar after) {
        return (int)CalendarUtil.elapsedMillis(before, after, 60000);
    }

    public static int elapsedSeconds(Calendar before, Calendar after) {
        return (int)CalendarUtil.elapsedMillis(before, after, 1000);
    }

    public static long elapsedMillis(Calendar before, Calendar after) {
        return CalendarUtil.elapsedMillis(before, after, 1);
    }

    public static int[] elapsedTime(Calendar before, Calendar after) {
        int[] elapsedTime = new int[6];
        Calendar clone = (Calendar)before.clone();
        elapsedTime[0] = CalendarUtil.elapsedYears(clone, after);
        CalendarUtil.addYears(clone, elapsedTime[0]);
        elapsedTime[1] = CalendarUtil.elapsedMonths(clone, after);
        CalendarUtil.addMonths(clone, elapsedTime[1]);
        elapsedTime[2] = CalendarUtil.elapsedDays(clone, after);
        CalendarUtil.addDays(clone, elapsedTime[2]);
        elapsedTime[3] = CalendarUtil.elapsedHours(clone, after);
        CalendarUtil.addHours(clone, elapsedTime[3]);
        elapsedTime[4] = CalendarUtil.elapsedMinutes(clone, after);
        CalendarUtil.addMinutes(clone, elapsedTime[4]);
        elapsedTime[5] = CalendarUtil.elapsedSeconds(clone, after);
        return elapsedTime;
    }

    private static int elapsed(Calendar before, Calendar after, int field) {
        CalendarUtil.checkBeforeAfter(before, after);
        Calendar clone = (Calendar)before.clone();
        int elapsed = -1;
        while (!clone.after(after)) {
            clone.add(field, 1);
            ++elapsed;
        }
        return elapsed;
    }

    private static long elapsedMillis(Calendar before, Calendar after, int factor) {
        CalendarUtil.checkBeforeAfter(before, after);
        if (factor < 1) {
            throw new IllegalArgumentException("Division factor '" + factor + "' should not be less than 1.");
        }
        return (after.getTimeInMillis() - before.getTimeInMillis()) / (long)factor;
    }

    private static void checkBeforeAfter(Calendar before, Calendar after) {
        if (before.after(after)) {
            throw new IllegalArgumentException("The first calendar should be dated before the second calendar.");
        }
    }
}

